# 项目九 物联网通信技术

## 一、项目要求

1. 使用VSPD虚拟串口软件创建串口连接
2. 使用Modbus Poll、Modbus Slave仿真软件完成主站、从站的模拟
3. 完成Modbus现场总线通信系统的组建

## 二、学习目标

1. 理解物联网通信技术的基本概念；
2. 掌握物联网通信技术的关键技术和标准；
3. 熟悉物联网通信的相关标准和协议；
4. 了解物联网通信技术的发展历程与趋势；
5. 掌握物联网通信系统的设计与实现。

## 三、相关知识

### 1.物联网通信技术概述

物联网通信技术是指通过利用无线通信、传感器技术、云计算等手段，将各种智能设备、传感器和物理对象连接到互联网，实现设备之间的互联互通、数据采集和信息交换的技术。这一技术作为物联网的基础和关键技术之一，对于推动物联网的发展和应用具有重要意义。

常见的物联网通信技术包括：LoRa、NB-IoT、ZigBee、Wi-Fi与蓝牙。

### 2.LoRa（Long Range Radio）

LoRa（Long Range Radio）是由美国Semtech公司开发的一种基于扩频技术的无线通信协议，主要用于实现长距离、低功耗的物联网通信，其核心是基于Chirp Spread Spectrum（CSS）调制方式。

### 3.NB-IoT（Narrowband Internet of Things）

NB-IoT（Narrow Band Internet of Things，窄带物联网）是一种低功耗广域（LPWA）网络技术标准，专为物联网应用设计。具有低功耗、覆盖广、构建于现有的蜂窝网络之上等特点。

### 4.ZigBee

ZigBee技术是一种广泛应用于物联网领域的短距离、低功耗、低速率、低成本的无线通信技术。ZigBee技术过去也被称为“HomeRF Lite”和“FireFly”技术，现在统一称为ZigBee技术。其名称的灵感来源于蜜蜂通过Z字形飞行来通知同伴食物源位置的交流方式，寓意着ZigBee技术能够像蜜蜂一样在设备间高效、可靠地传递信息。

### 5.WIFI通信协议

WIFI，全称Wireless Fidelity，是一种基于IEEE 802.11标准的无线局域网技术。它允许电子设备（如智能手机、平板电脑、笔记本电脑等）在无需物理连线的情况下接入互联网或局域网。

WIFI产品需经过Wi-Fi联盟的独立授权测试实验室进行严格测试，通过测试后授予制造商或销售商使用Wi-Fi标志、Wi-Fi CERTIFIED标志及相关商标。

### 9.3.5 物联网通信技术的发展趋势

随着技术的不断发展，物联网通信技术呈现出以下发展趋势：

（1）5G与物联网融合：5G技术的引入将大幅提升物联网的传输速度和覆盖范围。

（2）AI能力增强：AI技术将与物联网通信技术深度融合，提升数据处理和分析能力。

（3）卫星互联网与地面网融合：实现天地一体化网络覆盖。

## 四、操作步骤

### 步骤1：仿真软件的安装

软件安装的过程非常简单, 基本只需要点击下一步即可。

#### 1.安装VSPD

双击打开安装程序

![img](pic/204.jpg) 

点击OK，点击Next

选择"I accept the agreement", 点击Next；可以视情况选择修改软件安装位置。点击Next

![img](pic/205.jpg) 

点击Next；点击Install，等待软件安装完成

![img](pic/206.jpg) 

软件安装完成后，可以在桌面看到软件的图标。

#### 2.安装Modbus Poll仿真软件

仿真软件的安装与VSPD类似，这里仅展示安装过程截图:

 

![img](pic/207.jpg) 

 

![img](pic/208.jpg) 

之后一直点击Next，完成软件安装。软件安装完成后，桌面能看到软件的图标。

![img](pic/209.jpg) 

### 步骤2：安装Modbus Slave仿真软件

![img](pic/210.jpg) 

 

![img](pic/211.jpg) 

之后一直点击Next，完成软件安装。软件安装完成后，桌面能看到软件的图标。

![img](pic/212.jpg) 

### 步骤3：组建Modbus网络通信

#### 1.使用VSPD创建虚拟串口

双击桌面图标，打开串口模拟软件VSPD。软件界面如下:

![img](pic/213.jpg) 

点击创建端口对。之所以要创建一对，因为这里模拟的是一根线缆的两端，一端连接主机设备，另一端连接从机设备。

![img](pic/214.jpg) 

 

![img](pic/215.jpg) 

在 此电脑-->右键-->管理-->设备管理器->端口 中查看是否新加了两个虚拟端口:

![img](pic/216.jpg) 

#### 2.使用Modbus Slave创建一个Modbus从机

双击桌面Modbus Slave图标，软件界面如下:

![img](pic/217.jpg) 

点击 Connection -> Connect:

![img](pic/218.jpg) 

此时若软件未注册，会提示输入注册码。注册码可在软件压缩包中找到，粘贴后点击OK即可。

以下是创建连接的界面:

![img](pic/219.jpg) 

此时完成虚拟从机的创建。

#### 3.使用Modbus Poll创建一个Modbus主机

击桌面Modbus Poll图标打开软件，Poll软件界面与Slave软件基本一致。

点击Setup--Read/Write Definition...，确认参数设置。若有需要，可在设置界面修改Modbus的通信参数。

![img](pic/220.jpg) 

![img](pic/221.jpg) 

点击 Connection -> Connect， 若同样遇到注册码问题，请参考Modbus Slave的操作方式进行注册。

![img](pic/222.jpg) 

此时完成虚拟主机的创建。

#### 4.练习: 主机-从机通信操作

修改从机寄存器数据：

双击Modbus Slave软件界面值空白处

![img](pic/223.jpg) 

点击Display --> Communication, 可以看到通信记录:

![img](pic/224.jpg) 

![img](pic/225.jpg) 

Rx表示从机接收到的主机消息帧, 格式报文对应含义如下表:

| 01   | 03   | 00               | 00                   | 00         | 0A   | C5   | CD   |
| ---- | ---- | ---------------- | -------------------- | ---------- | ---- | ---- | ---- |
| 从站地址 | 功能码  | 读取的起始寄存器地址0x0000 | 查询的寄存器数量为0x000A(10)个 | 循环冗余校验 CRC |      |      |      |

Tx为从机发送到主机的回复报文，以类似方式组织:

从站地址 | 功能码 | 字节计数 | 字节1 | 字节N | 冗余校验

此时，查看Modbus Poll软件界面，发现寄存器0的值也变成了1。表示接收到了从机发过来的修改数据。

![img](pic/226.jpg) 

主机发送报文，从机接收到报文：

点击Modbus Poll软件界面，点击 Functions --> 06：Write Single Register

![img](pic/227.jpg) 

![img](pic/228.jpg) 

点击发送后，从机上对应地址的寄存器的值会变成发送的数据。

![img](pic/229.jpg) 

尝试通过主机发送不同的信息，修改从机上不同位置寄存器的值。

## 五、项目总结

​	在本章中，我们学习了物联网通信技术的相关知识，了解了不同的物联网通信技术。